﻿var groups = {
    context: $(".v-groups"),
    datatable: null,
    treeview: null,
    selectedRole: null,
    initializeDataTable: function (roleId) {
        var contextMenuItems = [
            { "Action": "editUsers", "Label": resources.EditUsers },
            { "Action": "editPermissions", "Label": resources.EditPermissions, "DisplayCondition": function (data) { return !data.IsSystemGroup && hasAcuity; } },
            { "Divider": true },
            { "Action": "copy", "Label": resources.Copy },
            { "Action": "delete", "Label": resources.Delete, "DisplayCondition": function (data) { return !data.IsSystemGroup; } },
            { "Action": "properties", "Label": resources.Properties, "DisplayCondition": function (data) { return !data.IsSystemGroup; } }];

        var toolBarItems = [{ "Action": "add", "Label": resources.AddToRole, "DisplayCondition": function (data) { return !groups.selectedRole || groups.selectedRole.Id == 0; } },
                            { "Action": "remove", "Label": resources.RemoveFromRole, "DisplayCondition": function (data) { return groups.selectedRole && groups.selectedRole.Id > 0; } },
                            { "Action": "delete", "Label": resources.Delete }];

        this.datatable = $(".v-groupsTable").a4datatable({
            height: "full",
            stateKey: "UsersRolesAndGroups",
            ajaxAction: a4.getAction("GetGroups", "Users", "Settings"),
            columns: [
                { "Name": "Id", "Title": resources.Id, "Data": "Id", "Visible": false, "Key": true },
                { "Name": "Name", "Title": resources.Name, "Data": "Name" },
                { "Name": "CreationDate", "Title": resources.CreationDate, "Data": "CreationDate" },
                { "Name": "CreatedByName", "Title": resources.CreatedBy, "Data": "CreatedByName" },
                { "Name": "LastModificationDate", "Title": resources.LastModificationDate, "Data": "LastModificationDate" },
                { "Name": "LastModifiedByName", "Title": resources.LastModifiedBy, "Data": "LastModifiedByName" },
                { "Name": "MfaActive", "Title": resources.Mfa, "Data": "MfaActive", "Type": "boolean", "ShowIcon": true, "Visible": mfaEnabled, "HideInSelector": !mfaEnabled }
            ],
            defaultSorting: "Name",
            allowRowSelection: function (data) { return !data.IsSystemGroup; },
            toolBarItems: toolBarItems,
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = _.map(rows, function (row) { return row.Id });

                switch (action) {
                    case "add":
                        groups.addGroupsToRoles(ids);
                        break;
                    case "remove":
                        groups.removeGroupsFromRole(ids);
                        break;
                    case "delete":
                        groups.deleteGroups(ids);
                        break;
                }
            },
            contextMenuItems: contextMenuItems,
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "editUsers":
                        modalDialog.showWindow(a4.getAction("EditGroupUsers", "Users", "Settings", { groupId: row.Id }), 550, 800);
                        break;
                    case "editRoles":
                        modalDialog.showWindow(a4.getAction("EditGroupRoles", "Users", "Settings", { groupId: row.ExternalId }), 550, 800);
                        break;
                    case "properties":
                        modalDialog.showWindow(a4.getAction("GroupProperties", "Users", "Settings", { groupId: row.Id }), 400, 600, { afterClose: function () { groups.refreshContent(); } });
                        break;
                    case "copy":
                        groups.copyGroup(row);
                        break;
                    case "delete":
                        groups.deleteGroups([row.Id]);
                        break;
                    case "editPermissions":
                        modalDialog.showWindow(a4.getAction("PermissionsEditor", "Users", "Settings", { groupId: row.Id, name: row.Name, isGroup: true }), "100%", 950);
                        break;
                }
            },
            localizableTexts: { "All": resources.AllGroups, "Search": resources.SearchUserGroups }
        });
    },
    initializeTreeView: function () {
        this.treeview = $(".h-roles", this.context).a4listview({
            ajaxAction: a4.getAction("GetRoles", "Users", "Settings"),
            customItems: [
                { Action: "all", Name: resources.AllUserGroups }
            ],
            draw: function (event, data) {
                var role = data.selectedNode;
                var roleId = role ? role.Id : null;

                if (groups.datatable) {
                    groups.datatable.a4datatable("option", "ajaxParams", { "roleId": roleId });
                    groups.datatable.a4datatable("refresh");
                }
                else {
                    groups.initializeDataTable(roleId);
                }
            },
            icons: null,
            selectNode: function (event, data) {
                var tableParams = {};

                if (data.isCustom) {
                    groups.selectedRole = null;
                    tableParams.roleId = null;
                }
                else {
                    groups.selectedRole = data.node;
                    tableParams.roleId = data.node ? data.node.Id : null;
                }

                groups.datatable.a4datatable("option", "ajaxParams", tableParams);
                groups.datatable.a4datatable("refresh", true);
            },
            actionButtons: [
                { Action: "editPermissions", Label: resources.EditPermissions, Icon: "lock", DisplayCondition: function (data) { return !data.IsSystemRole && data.Id > 0; } },
                { Action: "assignGroups", Label: resources.AssignUserGroups, Icon: "group", DisplayCondition: function (data) { return data.Id > 0; } },
                { Action: "copy", Label: resources.Copy, Icon: "copy", DisplayCondition: function (data) { return !data.IsSystemRole && data.Id > 0; } },
                { Action: "delete", Label: resources.Delete, Icon: "remove", DisplayCondition: function (data) { return !data.IsSystemRole && data.Id > 0; } },
                { Action: "properties", Label: resources.Properties, Icon: "edit", DisplayCondition: function (data) { return !data.IsSystemRole && data.Id > 0; } }
            ],
            actionButtonClick: function (event, data) {
                var action = data.action;
                var node = data.node;

                switch (action) {
                    case "editPermissions":
                        modalDialog.showWindow(a4.getAction("RolePermissionsEditor", "Users", "Settings", { roleId: node.Id, name: node.Name }), 700, 800, { afterClose: function () { groups.refreshContent(); } });
                        break;
                    case "assignGroups":
                        modalDialog.showWindow(a4.getAction("EditRoleGroups", "Users", "Settings", { roleId: node.Id }), 550, 800, { afterClose: function () { groups.refreshContent(); } });
                        break;
                    case "copy":
                        groups.copyRole(node);
                        break;
                    case "delete":
                        groups.deleteRole(node);
                        break;
                    case "properties":
                        modalDialog.showWindow(a4.getAction("RoleProperties", "Users", "Settings", { roleId: node.Id }), 200, 600, { afterClose: function () { groups.refreshContent(); } });
                        break;
                }
            },
            localizableTexts: { "Search": resources.SearchRoles }
        });
    },
    bindEvents: function () {
        groups.context.on("click", ".h-addGroup", function () {
            var roleId = null;
            
            if (groups.selectedRole)
                roleId = groups.selectedRole.Id;

            modalDialog.showWindow(a4.getAction("GroupProperties", "Users", "Settings", { roleId: roleId }), 300, 600, { afterClose: function () { groups.refreshContent(); } });
        });

        groups.context.on("click", ".h-addRole", function () {
            modalDialog.showWindow(a4.getAction("RoleProperties", "Users", "Settings"), 200, 600, { afterClose: function () { groups.refreshContent(); } });
        });
    },
    copyGroup: function (group) {
        a4.callServerMethod(a4.getAction("CopyGroup", "Users", "Settings"), { groupId: group.Id, name: group.Name },
            function (result) {
                groups.refreshDataTable();
                a4.showSuccessMessage(resources.UserGroupCreated.replace("{0}", result.newName));
            });
    },
    addGroupsToRoles: function (groupIds) {
        modalDialog.showWindow(a4.getAction("AddGroupsToRoles", "Users", "Settings", { groupIds: groupIds.join(",") }), 400, 500, { afterClose: function () { groups.refreshContent(); } });
    },
    removeGroupsFromRole: function (ids) {
        if (ids.length > 0 && groups.selectedRole)
        {
            modalDialog.showConfirmDialog(confirmRemoveGroupsResources, function () {
                a4.callServerMethod(a4.getAction("RemoveGroupsFromRole", "Users", "Settings"), { roleId: groups.selectedRole.Id, groupIds: ids },
                    function (result) {
                        groups.refreshContent();
                    });
            }, 220, 500, false, { "count": ids.length, "role": groups.selectedRole.Name });
        }
    },
    deleteGroups: function (ids) {
        if (ids.length > 0)
        {
            modalDialog.showConfirmDelete(confirmDeleteGroupsResources, function () {
                a4.callServerMethod(a4.getAction("DeleteGroups", "Users", "Settings"), { groupIds: ids },
                    function (result) {
                        groups.refreshDataTable();
                    });
            }, ids.length);
        }
    },
    addGroup: function (name) {
        a4.callServerMethod(a4.getAction("AddGroup", "Users", "Settings"), { name: name },
            function (result) {
                groups.refreshDataTable();
            });
    },
    editGroup: function (id, previousName, newName) {
        if (previousName != newName)
        {
            a4.callServerMethod(a4.getAction("RenameGroup", "Users", "Settings"), { groupId: id, name: newName },
                function (result) {
                    groups.refreshDataTable();
                });
        }
    },
    copyRole: function (role) {
        a4.callServerMethod(a4.getAction("CopyRole", "Users", "Settings"), { sourceRoleId: role.Id, name: role.Name },
            function (result) {
                groups.refreshContent();
                a4.showSuccessMessage(resources.RoleCreated.replace("{0}", result.newName));
            });
    },
    deleteRole: function (role) {
        modalDialog.showConfirmDialog(confirmDeleteRoleResources, function () {
            a4.callServerMethod(a4.getAction("DeleteRoles", "Users", "Settings"), { itemIds: [role.Id] },
                function (result) {
                    groups.refreshContent();
                });
        }, 250, 500, true, { "role": role.Name });
    },
    refreshDataTable: function () {
        groups.datatable.a4datatable("refresh");
    },
    refreshContent: function () {
        groups.treeview.a4listview("refresh");
    }
}

$(document).ready(function () {
    if (groups.context.length > 0)
    {
        groups.initializeTreeView();
        groups.bindEvents();
    }
});